@extends('layouts.admin')
@section('page-title')
    {{__('Warehouse Report')}}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item">{{ __('Warehouse Report') }}</li>
@endsection
@push('script-page')
    <script src="{{ asset('assets/js/plugins/apexcharts.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/html2pdf.bundle.min.js') }}"></script>
    <script>
        var filename = $('#filename').val();

        function saveAsPDF() {
            var element = document.getElementById('printableArea');
            var opt = {
                margin: 0.3,
                filename: filename,
                image: {type: 'jpeg', quality: 1},
                html2canvas: {scale: 4, dpi: 72, letterRendering: true},
                jsPDF: {unit: 'in', format: 'A2'}
            };
            html2pdf().set(opt).from(element).save();
        }
    </script>

    <script>
        (function () {
            var chartBarOptions = {
                series: [
                    {
                        name: '{{ __("Product") }}',
                        data:  {!! json_encode($warehouseProductData) !!},
                        // data:  [150,90,160,80],
                    },
                ],

                chart: {
                    height: 300,
                    type: 'area',
                    dropShadow: {
                        enabled: true,
                        color: '#000',
                        top: 18,
                        left: 7,
                        blur: 10,
                        opacity: 0.2
                    },
                    toolbar: {
                        show: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 2,
                    curve: 'smooth'
                },
                title: {
                    text: '',
                    align: 'left'
                },
                xaxis: {
                    categories: {!! json_encode($warehousename) !!},
                    title: {
                        text: '{{ __("Warehouse") }}'
                    }
                },
                colors: ['#6fd944'],


                grid: {
                    strokeDashArray: 4,
                },
                legend: {
                    show: false,
                },

                {{--yaxis: {--}}
                {{--    title: {--}}
                {{--        text: '{{ __("Product") }}'--}}
                {{--    },--}}

                {{--}--}}

            };
            var arChart = new ApexCharts(document.querySelector("#warehouse_report"), chartBarOptions);
            arChart.render();
        })();

    </script>

@endpush
@section('action-btn')
    <div class="float-end">
        <a href="#" class="btn btn-sm btn-primary" onclick="saveAsPDF()"data-bs-toggle="tooltip" title="{{__('Download')}}" data-original-title="{{__('Download')}}">
            <span class="btn-inner--icon"><i class="ti ti-download"></i></span>
        </a>
    </div>
@endsection

@section('content')

    <div id="printableArea">
        <div class="row mt-0 mb-4 gy-4">
            <div class="col-xl-4 col-sm-6 col-12 warehouse-card">
                <div class="warehouse-card-inner">
                    <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                            fill="#FF3A6E"></path>
                    </svg>
                    <div class="info-wrp d-flex align-items-center justify-content-between gap-3 ">
                        <div class="info-wrp-inner d-flex align-items-center gap-3">
                            <div class="warehouse-icon">
                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M3.271 2.87233H4.20978V18.4831C4.20978 19.1701 4.76884 19.7292 5.45583 19.7292H17.1887V20.668C17.1887 21.023 16.8992 21.3125 16.5442 21.3125H3.271C2.91599 21.3125 2.62646 21.023 2.62646 20.668V3.51686C2.62651 3.1619 2.91603 2.87233 3.271 2.87233ZM5.45587 0.6875C5.10086 0.6875 4.81134 0.977023 4.81134 1.33203V18.4831C4.81134 18.8381 5.10086 19.1277 5.45587 19.1277H18.7291C19.0841 19.1277 19.3736 18.8381 19.3736 18.4831V4.28746H17.0198C16.3328 4.28746 15.7737 3.7284 15.7737 3.04137V0.6875H5.45587ZM7.2585 4.76205H12.8015C12.9676 4.76205 13.1022 4.62739 13.1022 4.46127C13.1022 4.29516 12.9676 4.16049 12.8015 4.16049H7.2585C7.09238 4.16049 6.95772 4.29516 6.95772 4.46127C6.95772 4.62735 7.09238 4.76205 7.2585 4.76205ZM7.2585 6.21225H10.4167C10.5828 6.21225 10.7175 6.07759 10.7175 5.91147C10.7175 5.74535 10.5828 5.61069 10.4167 5.61069H7.2585C7.09238 5.61069 6.95772 5.74535 6.95772 5.91147C6.95772 6.07754 7.09238 6.21225 7.2585 6.21225ZM16.3752 3.04141C16.3752 3.39642 16.6647 3.68595 17.0197 3.68595H19.3177C19.2865 3.6175 19.2421 3.55446 19.1848 3.49714L16.564 0.876305C16.5067 0.818984 16.4437 0.774641 16.3752 0.743402V3.04141H16.3752ZM7.47334 13.1185C7.355 13.1185 7.2585 13.215 7.2585 13.3333V16.0321C7.2585 16.1504 7.355 16.247 7.47334 16.247H8.55194C8.67028 16.247 8.76679 16.1504 8.76679 16.0321V13.3333C8.76679 13.215 8.67028 13.1185 8.55194 13.1185H7.47334ZM10.1932 11.7575C10.0749 11.7575 9.97838 11.854 9.97838 11.9723V16.0321C9.97838 16.1504 10.0749 16.247 10.1932 16.247H11.2718C11.3902 16.247 11.4867 16.1504 11.4867 16.0321C11.4867 14.6789 11.4867 13.3256 11.4867 11.9723C11.4867 11.854 11.3902 11.7575 11.2718 11.7575C10.9123 11.7575 10.5528 11.7575 10.1932 11.7575ZM12.9131 10.3964C12.7948 10.3964 12.6983 10.4929 12.6983 10.6112V16.0321C12.6983 16.1504 12.7948 16.2469 12.9131 16.2469H13.9917C14.1101 16.2469 14.2066 16.1504 14.2066 16.0321C14.2066 14.2251 14.2066 12.4182 14.2066 10.6112C14.2066 10.4929 14.1101 10.3964 13.9917 10.3964C13.6322 10.3964 13.2727 10.3964 12.9131 10.3964ZM15.6331 9.03534C15.5147 9.03534 15.4182 9.13185 15.4182 9.25018V16.0321C15.4182 16.1504 15.5147 16.2469 15.6331 16.2469H16.7117C16.83 16.2469 16.9265 16.1504 16.9265 16.0321V9.25018C16.9265 9.13185 16.83 9.03534 16.7117 9.03534H15.6331ZM13.9129 6.74876L14.3784 6.62797C13.761 7.5527 12.8977 8.37968 11.8507 9.04509C10.6097 9.83383 9.11384 10.3941 7.46578 10.6209C7.30164 10.6429 7.18644 10.7939 7.20848 10.9581C7.23052 11.1223 7.38152 11.2375 7.5457 11.2154C9.28482 10.9761 10.8632 10.3849 12.1727 9.55264C13.2473 8.86969 14.143 8.02334 14.8007 7.07438L14.8238 7.42448C14.8341 7.58996 14.9767 7.71568 15.1422 7.70529C15.3077 7.69489 15.4334 7.55236 15.423 7.38689L15.3397 6.12764C15.3248 5.90292 15.0908 5.8236 14.8778 5.8789L13.7625 6.16834C13.6023 6.20984 13.506 6.37347 13.5475 6.53374C13.589 6.69402 13.7526 6.79031 13.9129 6.74876Z"
                                        fill="white" />
                                </svg>
                            </div>
                            <h2 class="h4 mb-0">{{ __('Warehouse Report') }}</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-sm-6 col-12 warehouse-card">
                <div class="warehouse-card-inner">
                    <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                            fill="#FF3A6E"></path>
                    </svg>
                    <div class="info-wrp d-flex align-items-center justify-content-between gap-3 ">
                        <div class="info-wrp-inner d-flex align-items-center gap-3">

                            <div class="warehouse-icon">
                                <svg width="28" height="27" viewBox="0 0 28 27" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M17.3333 8.16675H18.9999V11.0834H17.3333V8.16675Z" fill="#FFA21D" />
                                    <path
                                        d="M22.7499 8.58341V16.9167C22.7499 17.1459 22.5624 17.3334 22.3333 17.3334H13.9999C13.7708 17.3334 13.5833 17.1459 13.5833 16.9167V8.58341C13.5833 8.35425 13.7708 8.16675 13.9999 8.16675H16.4999V11.5001C16.4999 11.7292 16.6874 11.9167 16.9166 11.9167H19.4166C19.6458 11.9167 19.8333 11.7292 19.8333 11.5001V8.16675H22.3333C22.5624 8.16675 22.7499 8.35425 22.7499 8.58341Z"
                                        fill="#FFA21D" />
                                    <path d="M12.3333 17.75H13.9999V20.6667H12.3333V17.75Z" fill="#FFA21D" />
                                    <path
                                        d="M17.7499 18.1667V26.5C17.7499 26.7292 17.5624 26.9167 17.3333 26.9167H8.99992C8.77075 26.9167 8.58325 26.7292 8.58325 26.5V18.1667C8.58325 17.9375 8.77075 17.75 8.99992 17.75H11.4999V21.0833C11.4999 21.3125 11.6874 21.5 11.9166 21.5H14.4166C14.6458 21.5 14.8333 21.3125 14.8333 21.0833V17.75H17.3333C17.5624 17.75 17.7499 17.9375 17.7499 18.1667Z"
                                        fill="#FFA21D" />
                                    <path d="M22.3333 17.75H23.9999V20.6667H22.3333V17.75Z" fill="#FFA21D" />
                                    <path
                                        d="M27.7499 18.1667V26.5C27.7499 26.7292 27.5624 26.9167 27.3333 26.9167H18.9999C18.7708 26.9167 18.5833 26.7292 18.5833 26.5V18.1667C18.5833 17.9375 18.7708 17.75 18.9999 17.75H21.4999V21.0833C21.4999 21.3125 21.6874 21.5 21.9166 21.5H24.4166C24.6458 21.5 24.8333 21.3125 24.8333 21.0833V17.75H27.3333C27.5624 17.75 27.7499 17.9375 27.7499 18.1667Z"
                                        fill="#FFA21D" />
                                    <path
                                        d="M27.5458 8.64169L14.2124 0.725024C14.0833 0.645858 13.9166 0.645858 13.7874 0.725024L0.454092 8.64169C0.254092 8.75836 0.191592 9.01669 0.308259 9.21252C0.424926 9.40836 0.683259 9.47502 0.879092 9.35836L1.91659 8.74169V26.5C1.91659 26.7292 2.10409 26.9167 2.33326 26.9167H6.08326C6.31243 26.9167 6.49993 26.7292 6.49993 26.5V13.1667H12.7499V8.58336C12.7499 7.89586 13.3124 7.33336 13.9999 7.33336H22.3333C23.0208 7.33336 23.5833 7.89586 23.5833 8.58336V17.3334H26.0833V8.74169L27.1208 9.35836C27.1874 9.40002 27.2624 9.41669 27.3333 9.41669C27.4749 9.41669 27.6124 9.34586 27.6916 9.21252C27.8083 9.01669 27.7458 8.75836 27.5458 8.64169ZM16.0833 5.66669H11.9166C11.6874 5.66669 11.4999 5.47919 11.4999 5.25002C11.4999 5.02086 11.6874 4.83336 11.9166 4.83336H16.0833C16.3124 4.83336 16.4999 5.02086 16.4999 5.25002C16.4999 5.47919 16.3124 5.66669 16.0833 5.66669Z"
                                        fill="#FFA21D" />
                                </svg>

                            </div>
                            <h2 class="h4 mb-0">{{ __('Total Warehouse') }}:</h2>
                        </div>
                        <h4 class="mb-0">{{ $totalWarehouse }}</h4>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-sm-6 col-12 warehouse-card">
                <div class="warehouse-card-inner">
                    <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                            fill="#FF3A6E"></path>
                    </svg>
                    <div class="info-wrp d-flex align-items-center justify-content-between gap-3 ">
                        <div class="info-wrp-inner d-flex align-items-center gap-3">
                            <div class="warehouse-icon">
                                <svg width="30" height="30" viewBox="0 0 30 30" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M11.7719 25.8617L11.7779 21.9108C11.7786 21.4254 11.7478 20.9577 11.629 20.5387C11.5202 20.1544 11.3325 19.8075 11.0156 19.5219C10.7618 19.2931 10.5073 19.0786 10.2257 18.8413C9.35526 18.1077 8.2486 17.175 7.33301 16.0989C6.9879 15.8035 6.47327 15.7656 6.13905 16.0998C5.97569 16.2632 5.88979 16.4462 5.88528 16.6334C5.881 16.8098 5.94423 17.0036 6.0777 17.2046C6.58219 17.7838 7.08821 18.2753 7.6237 18.7954C7.88585 19.05 8.15432 19.3108 8.33919 19.4956C8.52223 19.6787 8.52223 19.9755 8.33919 20.1585C8.15614 20.3415 7.85936 20.3415 7.67637 20.1585C7.3738 19.8559 7.17053 19.6585 6.97184 19.4655C6.27464 18.7883 5.6369 18.1577 5.03145 17.4126C4.76327 17.0824 4.55643 16.7328 4.41581 16.3561C4.27424 15.9767 4.20176 15.5746 4.20335 15.1422L4.22385 9.76134C4.22901 8.40443 3.90839 7.71566 3.50022 7.44917C3.37202 7.3655 3.23374 7.32607 3.09645 7.32167C2.94997 7.31699 2.80132 7.35062 2.66309 7.41244C2.32987 7.56138 2.07223 7.85722 2.06362 8.16168L1.78296 18.0671C1.76081 18.8518 2.04124 19.5164 2.5943 20.0694L7.07473 24.5499C7.17657 24.6517 7.22169 24.7887 7.2102 24.9218V25.9008L11.7719 25.8617ZM21.7054 12.4024C21.7054 12.6176 21.5987 12.8022 21.4124 12.9098L15.293 16.4428C15.1067 16.5504 14.8934 16.5504 14.7072 16.4428L8.5878 12.9098C8.40147 12.8022 8.29483 12.6176 8.29483 12.4024V5.33634C8.29483 5.12119 8.40147 4.9365 8.5878 4.82892L14.7071 1.29589C14.8934 1.18832 15.1067 1.18832 15.293 1.29589L17.3804 2.50105L10.6751 6.37234V9.08294C10.6751 9.2981 10.7817 9.48279 10.9681 9.59037L12.1802 10.2902C12.2733 10.3439 12.38 10.3439 12.4732 10.2902C12.5663 10.2364 12.6196 10.144 12.6196 10.0364V7.495L19.3249 3.62371L21.4123 4.82886C21.5987 4.93644 21.7053 5.12113 21.7053 5.33628V12.4024H21.7054ZM13.1663 26.7836L5.3795 26.8505C5.3209 26.851 5.26694 26.8763 5.22733 26.9166C5.18784 26.9568 5.16358 27.0113 5.16405 27.0704L5.17694 28.5694C5.17741 28.628 5.20272 28.6819 5.24303 28.7215C5.28317 28.761 5.33772 28.7853 5.39684 28.7848L13.1836 28.7179C13.2422 28.7174 13.2962 28.6921 13.3358 28.6518C13.3753 28.6116 13.3996 28.557 13.399 28.498L13.3862 26.999C13.3857 26.9404 13.3604 26.8865 13.3201 26.8469C13.2799 26.8074 13.2253 26.7832 13.1663 26.7836ZM12.8782 27.585C12.9732 27.824 12.8565 28.0949 12.6175 28.1899C12.3784 28.2849 12.1076 28.1682 12.0125 27.9292C11.9175 27.6901 12.0342 27.4193 12.2733 27.3242C12.5124 27.2292 12.7832 27.346 12.8782 27.585ZM22.7898 25.9009V24.9219C22.7783 24.7889 22.8234 24.6518 22.9253 24.55L27.4057 20.0696C27.9588 19.5166 28.2392 18.8519 28.2171 18.0672L27.9364 8.16179C27.9278 7.8574 27.6701 7.5615 27.3369 7.41255C27.1988 7.3508 27.05 7.31716 26.9036 7.32179C26.7663 7.32619 26.6279 7.36556 26.4998 7.44929C26.0916 7.71572 25.7711 8.40449 25.7762 9.76146L25.7967 15.1423C25.7982 15.5747 25.7258 15.9768 25.5843 16.3562C25.4436 16.7329 25.2369 17.0825 24.9686 17.4127C24.3632 18.1579 23.7254 18.7884 23.0282 19.4656C22.8295 19.6586 22.6263 19.8559 22.3237 20.1586C22.1406 20.3416 21.8439 20.3416 21.6609 20.1586C21.4778 19.9755 21.4778 19.6787 21.6609 19.4958C21.8457 19.3109 22.1143 19.0501 22.3764 18.7955C22.9119 18.2754 23.4179 17.7839 23.9224 17.2047C24.0558 17.0038 24.1191 16.8099 24.1148 16.6335C24.1103 16.4463 24.0244 16.2633 23.861 16.1C23.5268 15.7657 23.0121 15.8036 22.6671 16.099C21.7514 17.1751 20.6448 18.1078 19.7743 18.8414C19.4927 19.0787 19.2382 19.2932 18.9844 19.522C18.6675 19.8076 18.4798 20.1545 18.371 20.5388C18.2523 20.9578 18.2214 21.4255 18.2222 21.9109L18.2282 25.8619L22.7898 25.9009ZM24.6206 26.8506L16.8339 26.7837C16.7748 26.7832 16.7203 26.8075 16.6801 26.847C16.6398 26.8866 16.6145 26.9405 16.614 26.9992L16.6011 28.4981C16.6006 28.5572 16.6249 28.6117 16.6644 28.6519C16.704 28.6922 16.7579 28.7175 16.8165 28.718L24.6032 28.7849C24.6623 28.7854 24.7168 28.7611 24.757 28.7216C24.7973 28.682 24.8226 28.6281 24.8231 28.5695L24.836 27.0705C24.8365 27.0114 24.8122 26.9569 24.7727 26.9167C24.7332 26.8763 24.6792 26.851 24.6206 26.8506ZM17.9875 27.585C18.0826 27.824 17.9658 28.0949 17.7268 28.1899C17.4877 28.2849 17.2169 28.1682 17.1219 27.9292C17.0268 27.6901 17.1435 27.4193 17.3826 27.3242C17.6217 27.2292 17.8925 27.346 17.9875 27.585Z"
                                        fill="#0CAF60" />
                                </svg>
                            </div>
                            <h2 class="h4 mb-0">{{ __('Total Product') }}:</h2>
                        </div>
                        <h4 class="mb-0">{{ $totalProduct }}</h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row ">
                            <div class="col-6">
                                <h6>{{ __('Warehouse Report') }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="warehouse_report"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection



